'use strict';

/* --------------------------------------------------------------
 orders_parcel_tracking.js 2024-09-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2024 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * ## Order Tracking Codes Controller
 *
 * @module Controllers/orders_parcel_tracking
 */
gx.controllers.module('orders_parcel_tracking', ['fallback'],

/** @lends module:Controllers/orders_parcel_tracking */

function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLE DEFINITION
    // ------------------------------------------------------------------------

    var
    /**
     * Module Selector
     *
     * @var {object}
     */
    $this = $(this),


    /**
     * Default Options
     *
     * @type {object}
     */
    defaults = {},


    /**
     * Final Options
     *
     * @var {object}
     */
    options = $.extend(true, {}, defaults, data),


    /**
     * Module Object
     *
     * @type {object}
     */
    module = {},


    /**
     * Flag to prevent multi-clicks on _addTrackingCode
     *
     * @type {boolean}
     */
    addTrackingCodeInProgress = false;

    // ------------------------------------------------------------------------
    // EVENT HANDLERS
    // ------------------------------------------------------------------------

    var _addTrackingCode = function _addTrackingCode(event) {

        event.stopPropagation();

        if (addTrackingCodeInProgress === true) {
            // prevent accidental multi-pressing
            return false;
        }
        addTrackingCodeInProgress = true;

        var orderId = options.orderId;
        var trackingNumber = $('#tracking-number').val();
        var parcelServiceId = $('#delivery-service option:selected').val();
        var isReturnDelivery = $('#isReturnDelivery').prop('checked') ? 'true' : 'false';
        var shipmentType = $('#shipmentType').val();

        console.log(options);

        $.ajax({
            url: './admin.php?do=OrdersModalsAjax/StoreTrackingNumber',
            data: {
                orderId: orderId,
                trackingNumber: trackingNumber,
                parcelServiceId: parcelServiceId,
                isReturnDelivery: isReturnDelivery,
                shipmentType: shipmentType,
                pageToken: jse.core.config.get('pageToken')
            },
            method: 'POST',
            dataType: 'JSON',
            success: function success(response) {
                if (response[0] === 'error') {
                    jse.libs.modal.message({
                        title: jse.core.lang.translate('error', 'messages'),
                        content: jse.core.lang.translate('TEXT_ADD_TRACKING_CODE_ERROR', 'orders')
                    });

                    return;
                }

                location.reload();
            },
            complete: function complete() {
                addTrackingCodeInProgress = false;
            }
        });

        return false;
    };

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    /**
     * Init function of the widget
     */
    module.init = function (done) {
        $('#tracking_code_wrapper a.add-tracking-code').on('click', function (event) {
            event.preventDefault();

            var modal = $('.add-tracking-number.modal-body');

            modal.dialog({
                'title': jse.core.lang.translate('HEADING_TRACKING_CODE', 'orders'),
                'modal': true,
                'dialogClass': 'gx-container',
                'buttons': [{
                    'text': jse.core.lang.translate('close', 'buttons'),
                    'class': 'btn',
                    'click': function click() {
                        $(this).dialog('close');
                    }
                }, {
                    'text': jse.core.lang.translate('add', 'buttons'),
                    'class': 'btn btn-primary',
                    'click': _addTrackingCode
                }],
                'width': 420
            });
        });

        done();
    };

    // Return data to widget engine
    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
